package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartAnonymousId {
  private String anonymousId;

  public SetCartAnonymousId() {
  }

  public SetCartAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  public String getAnonymousId() {
    return anonymousId;
  }

  public void setAnonymousId(String anonymousId) {
    this.anonymousId = anonymousId;
  }

  @Override
  public String toString() {
    return "SetCartAnonymousId{anonymousId='" + anonymousId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartAnonymousId that = (SetCartAnonymousId) o;
    return Objects.equals(anonymousId, that.anonymousId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(anonymousId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String anonymousId;

    public SetCartAnonymousId build() {
      SetCartAnonymousId result = new SetCartAnonymousId();
      result.anonymousId = this.anonymousId;
      return result;
    }

    public Builder anonymousId(String anonymousId) {
      this.anonymousId = anonymousId;
      return this;
    }
  }
}
