package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartCustomLineItemTaxAmount {
  private String customLineItemId;

  private String customLineItemKey;

  private ExternalTaxAmountDraft externalTaxAmount;

  private String shippingKey;

  public SetCartCustomLineItemTaxAmount() {
  }

  public SetCartCustomLineItemTaxAmount(String customLineItemId, String customLineItemKey,
      ExternalTaxAmountDraft externalTaxAmount, String shippingKey) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.externalTaxAmount = externalTaxAmount;
    this.shippingKey = shippingKey;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public ExternalTaxAmountDraft getExternalTaxAmount() {
    return externalTaxAmount;
  }

  public void setExternalTaxAmount(ExternalTaxAmountDraft externalTaxAmount) {
    this.externalTaxAmount = externalTaxAmount;
  }

  public String getShippingKey() {
    return shippingKey;
  }

  public void setShippingKey(String shippingKey) {
    this.shippingKey = shippingKey;
  }

  @Override
  public String toString() {
    return "SetCartCustomLineItemTaxAmount{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', externalTaxAmount='" + externalTaxAmount + "', shippingKey='" + shippingKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartCustomLineItemTaxAmount that = (SetCartCustomLineItemTaxAmount) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(externalTaxAmount, that.externalTaxAmount) &&
        Objects.equals(shippingKey, that.shippingKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, externalTaxAmount, shippingKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private ExternalTaxAmountDraft externalTaxAmount;

    private String shippingKey;

    public SetCartCustomLineItemTaxAmount build() {
      SetCartCustomLineItemTaxAmount result = new SetCartCustomLineItemTaxAmount();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.externalTaxAmount = this.externalTaxAmount;
      result.shippingKey = this.shippingKey;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder externalTaxAmount(ExternalTaxAmountDraft externalTaxAmount) {
      this.externalTaxAmount = externalTaxAmount;
      return this;
    }

    public Builder shippingKey(String shippingKey) {
      this.shippingKey = shippingKey;
      return this;
    }
  }
}
