package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SetCartDiscountValidFromAndUntil {
  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  public SetCartDiscountValidFromAndUntil() {
  }

  public SetCartDiscountValidFromAndUntil(OffsetDateTime validFrom, OffsetDateTime validUntil) {
    this.validFrom = validFrom;
    this.validUntil = validUntil;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  @Override
  public String toString() {
    return "SetCartDiscountValidFromAndUntil{validFrom='" + validFrom + "', validUntil='" + validUntil + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartDiscountValidFromAndUntil that = (SetCartDiscountValidFromAndUntil) o;
    return Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validFrom, validUntil);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    public SetCartDiscountValidFromAndUntil build() {
      SetCartDiscountValidFromAndUntil result = new SetCartDiscountValidFromAndUntil();
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      return result;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }
  }
}
