package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCartLineItemDistributionChannel {
  private String lineItemId;

  private ResourceIdentifierInput distributionChannel;

  private String lineItemKey;

  public SetCartLineItemDistributionChannel() {
  }

  public SetCartLineItemDistributionChannel(String lineItemId,
      ResourceIdentifierInput distributionChannel, String lineItemKey) {
    this.lineItemId = lineItemId;
    this.distributionChannel = distributionChannel;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public ResourceIdentifierInput getDistributionChannel() {
    return distributionChannel;
  }

  public void setDistributionChannel(ResourceIdentifierInput distributionChannel) {
    this.distributionChannel = distributionChannel;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetCartLineItemDistributionChannel{lineItemId='" + lineItemId + "', distributionChannel='" + distributionChannel + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCartLineItemDistributionChannel that = (SetCartLineItemDistributionChannel) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(distributionChannel, that.distributionChannel) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, distributionChannel, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private ResourceIdentifierInput distributionChannel;

    private String lineItemKey;

    public SetCartLineItemDistributionChannel build() {
      SetCartLineItemDistributionChannel result = new SetCartLineItemDistributionChannel();
      result.lineItemId = this.lineItemId;
      result.distributionChannel = this.distributionChannel;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder distributionChannel(ResourceIdentifierInput distributionChannel) {
      this.distributionChannel = distributionChannel;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
