package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetCategoryAssetCustomType {
  private String typeId;

  private String typeKey;

  private ResourceIdentifierInput type;

  private List<CustomFieldInput> fields;

  private String assetKey;

  private String assetId;

  public SetCategoryAssetCustomType() {
  }

  public SetCategoryAssetCustomType(String typeId, String typeKey, ResourceIdentifierInput type,
      List<CustomFieldInput> fields, String assetKey, String assetId) {
    this.typeId = typeId;
    this.typeKey = typeKey;
    this.type = type;
    this.fields = fields;
    this.assetKey = assetKey;
    this.assetId = assetId;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getTypeKey() {
    return typeKey;
  }

  public void setTypeKey(String typeKey) {
    this.typeKey = typeKey;
  }

  public ResourceIdentifierInput getType() {
    return type;
  }

  public void setType(ResourceIdentifierInput type) {
    this.type = type;
  }

  public List<CustomFieldInput> getFields() {
    return fields;
  }

  public void setFields(List<CustomFieldInput> fields) {
    this.fields = fields;
  }

  public String getAssetKey() {
    return assetKey;
  }

  public void setAssetKey(String assetKey) {
    this.assetKey = assetKey;
  }

  public String getAssetId() {
    return assetId;
  }

  public void setAssetId(String assetId) {
    this.assetId = assetId;
  }

  @Override
  public String toString() {
    return "SetCategoryAssetCustomType{typeId='" + typeId + "', typeKey='" + typeKey + "', type='" + type + "', fields='" + fields + "', assetKey='" + assetKey + "', assetId='" + assetId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryAssetCustomType that = (SetCategoryAssetCustomType) o;
    return Objects.equals(typeId, that.typeId) &&
        Objects.equals(typeKey, that.typeKey) &&
        Objects.equals(type, that.type) &&
        Objects.equals(fields, that.fields) &&
        Objects.equals(assetKey, that.assetKey) &&
        Objects.equals(assetId, that.assetId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeId, typeKey, type, fields, assetKey, assetId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String typeId;

    private String typeKey;

    private ResourceIdentifierInput type;

    private List<CustomFieldInput> fields;

    private String assetKey;

    private String assetId;

    public SetCategoryAssetCustomType build() {
      SetCategoryAssetCustomType result = new SetCategoryAssetCustomType();
      result.typeId = this.typeId;
      result.typeKey = this.typeKey;
      result.type = this.type;
      result.fields = this.fields;
      result.assetKey = this.assetKey;
      result.assetId = this.assetId;
      return result;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder typeKey(String typeKey) {
      this.typeKey = typeKey;
      return this;
    }

    public Builder type(ResourceIdentifierInput type) {
      this.type = type;
      return this;
    }

    public Builder fields(List<CustomFieldInput> fields) {
      this.fields = fields;
      return this;
    }

    public Builder assetKey(String assetKey) {
      this.assetKey = assetKey;
      return this;
    }

    public Builder assetId(String assetId) {
      this.assetId = assetId;
      return this;
    }
  }
}
