package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SetCategoryAssetSources {
  private List<AssetSourceInput> sources = Collections.emptyList();

  private String assetKey;

  private String assetId;

  public SetCategoryAssetSources() {
  }

  public SetCategoryAssetSources(List<AssetSourceInput> sources, String assetKey, String assetId) {
    this.sources = sources;
    this.assetKey = assetKey;
    this.assetId = assetId;
  }

  public List<AssetSourceInput> getSources() {
    return sources;
  }

  public void setSources(List<AssetSourceInput> sources) {
    this.sources = sources;
  }

  public String getAssetKey() {
    return assetKey;
  }

  public void setAssetKey(String assetKey) {
    this.assetKey = assetKey;
  }

  public String getAssetId() {
    return assetId;
  }

  public void setAssetId(String assetId) {
    this.assetId = assetId;
  }

  @Override
  public String toString() {
    return "SetCategoryAssetSources{sources='" + sources + "', assetKey='" + assetKey + "', assetId='" + assetId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryAssetSources that = (SetCategoryAssetSources) o;
    return Objects.equals(sources, that.sources) &&
        Objects.equals(assetKey, that.assetKey) &&
        Objects.equals(assetId, that.assetId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sources, assetKey, assetId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<AssetSourceInput> sources = Collections.emptyList();

    private String assetKey;

    private String assetId;

    public SetCategoryAssetSources build() {
      SetCategoryAssetSources result = new SetCategoryAssetSources();
      result.sources = this.sources;
      result.assetKey = this.assetKey;
      result.assetId = this.assetId;
      return result;
    }

    public Builder sources(List<AssetSourceInput> sources) {
      this.sources = sources;
      return this;
    }

    public Builder assetKey(String assetKey) {
      this.assetKey = assetKey;
      return this;
    }

    public Builder assetId(String assetId) {
      this.assetId = assetId;
      return this;
    }
  }
}
