package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SetCategoryAssetTags {
  private List<String> tags = Collections.emptyList();

  private String assetKey;

  private String assetId;

  public SetCategoryAssetTags() {
  }

  public SetCategoryAssetTags(List<String> tags, String assetKey, String assetId) {
    this.tags = tags;
    this.assetKey = assetKey;
    this.assetId = assetId;
  }

  public List<String> getTags() {
    return tags;
  }

  public void setTags(List<String> tags) {
    this.tags = tags;
  }

  public String getAssetKey() {
    return assetKey;
  }

  public void setAssetKey(String assetKey) {
    this.assetKey = assetKey;
  }

  public String getAssetId() {
    return assetId;
  }

  public void setAssetId(String assetId) {
    this.assetId = assetId;
  }

  @Override
  public String toString() {
    return "SetCategoryAssetTags{tags='" + tags + "', assetKey='" + assetKey + "', assetId='" + assetId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryAssetTags that = (SetCategoryAssetTags) o;
    return Objects.equals(tags, that.tags) &&
        Objects.equals(assetKey, that.assetKey) &&
        Objects.equals(assetId, that.assetId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tags, assetKey, assetId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> tags = Collections.emptyList();

    private String assetKey;

    private String assetId;

    public SetCategoryAssetTags build() {
      SetCategoryAssetTags result = new SetCategoryAssetTags();
      result.tags = this.tags;
      result.assetKey = this.assetKey;
      result.assetId = this.assetId;
      return result;
    }

    public Builder tags(List<String> tags) {
      this.tags = tags;
      return this;
    }

    public Builder assetKey(String assetKey) {
      this.assetKey = assetKey;
      return this;
    }

    public Builder assetId(String assetId) {
      this.assetId = assetId;
      return this;
    }
  }
}
