package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetCategoryDescription {
  private List<LocalizedStringItemInputType> description;

  public SetCategoryDescription() {
  }

  public SetCategoryDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  @Override
  public String toString() {
    return "SetCategoryDescription{description='" + description + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryDescription that = (SetCategoryDescription) o;
    return Objects.equals(description, that.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> description;

    public SetCategoryDescription build() {
      SetCategoryDescription result = new SetCategoryDescription();
      result.description = this.description;
      return result;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }
  }
}
