package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCategoryExternalId {
  private String externalId;

  public SetCategoryExternalId() {
  }

  public SetCategoryExternalId(String externalId) {
    this.externalId = externalId;
  }

  public String getExternalId() {
    return externalId;
  }

  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }

  @Override
  public String toString() {
    return "SetCategoryExternalId{externalId='" + externalId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryExternalId that = (SetCategoryExternalId) o;
    return Objects.equals(externalId, that.externalId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(externalId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String externalId;

    public SetCategoryExternalId build() {
      SetCategoryExternalId result = new SetCategoryExternalId();
      result.externalId = this.externalId;
      return result;
    }

    public Builder externalId(String externalId) {
      this.externalId = externalId;
      return this;
    }
  }
}
