package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetCategoryMetaTitle {
  private List<LocalizedStringItemInputType> metaTitle;

  public SetCategoryMetaTitle() {
  }

  public SetCategoryMetaTitle(List<LocalizedStringItemInputType> metaTitle) {
    this.metaTitle = metaTitle;
  }

  public List<LocalizedStringItemInputType> getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(List<LocalizedStringItemInputType> metaTitle) {
    this.metaTitle = metaTitle;
  }

  @Override
  public String toString() {
    return "SetCategoryMetaTitle{metaTitle='" + metaTitle + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCategoryMetaTitle that = (SetCategoryMetaTitle) o;
    return Objects.equals(metaTitle, that.metaTitle);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metaTitle);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> metaTitle;

    public SetCategoryMetaTitle build() {
      SetCategoryMetaTitle result = new SetCategoryMetaTitle();
      result.metaTitle = this.metaTitle;
      return result;
    }

    public Builder metaTitle(List<LocalizedStringItemInputType> metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }
  }
}
