package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetCustomerAddressCustomType {
  private List<CustomFieldInput> fields;

  private ResourceIdentifierInput type;

  private String typeKey;

  private String typeId;

  private String addressId;

  public SetCustomerAddressCustomType() {
  }

  public SetCustomerAddressCustomType(List<CustomFieldInput> fields, ResourceIdentifierInput type,
      String typeKey, String typeId, String addressId) {
    this.fields = fields;
    this.type = type;
    this.typeKey = typeKey;
    this.typeId = typeId;
    this.addressId = addressId;
  }

  public List<CustomFieldInput> getFields() {
    return fields;
  }

  public void setFields(List<CustomFieldInput> fields) {
    this.fields = fields;
  }

  public ResourceIdentifierInput getType() {
    return type;
  }

  public void setType(ResourceIdentifierInput type) {
    this.type = type;
  }

  public String getTypeKey() {
    return typeKey;
  }

  public void setTypeKey(String typeKey) {
    this.typeKey = typeKey;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  @Override
  public String toString() {
    return "SetCustomerAddressCustomType{fields='" + fields + "', type='" + type + "', typeKey='" + typeKey + "', typeId='" + typeId + "', addressId='" + addressId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerAddressCustomType that = (SetCustomerAddressCustomType) o;
    return Objects.equals(fields, that.fields) &&
        Objects.equals(type, that.type) &&
        Objects.equals(typeKey, that.typeKey) &&
        Objects.equals(typeId, that.typeId) &&
        Objects.equals(addressId, that.addressId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fields, type, typeKey, typeId, addressId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<CustomFieldInput> fields;

    private ResourceIdentifierInput type;

    private String typeKey;

    private String typeId;

    private String addressId;

    public SetCustomerAddressCustomType build() {
      SetCustomerAddressCustomType result = new SetCustomerAddressCustomType();
      result.fields = this.fields;
      result.type = this.type;
      result.typeKey = this.typeKey;
      result.typeId = this.typeId;
      result.addressId = this.addressId;
      return result;
    }

    public Builder fields(List<CustomFieldInput> fields) {
      this.fields = fields;
      return this;
    }

    public Builder type(ResourceIdentifierInput type) {
      this.type = type;
      return this;
    }

    public Builder typeKey(String typeKey) {
      this.typeKey = typeKey;
      return this;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }
  }
}
