package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerAuthenticationMode {
  private AuthenticationMode authMode;

  private String password;

  public SetCustomerAuthenticationMode() {
  }

  public SetCustomerAuthenticationMode(AuthenticationMode authMode, String password) {
    this.authMode = authMode;
    this.password = password;
  }

  public AuthenticationMode getAuthMode() {
    return authMode;
  }

  public void setAuthMode(AuthenticationMode authMode) {
    this.authMode = authMode;
  }

  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  @Override
  public String toString() {
    return "SetCustomerAuthenticationMode{authMode='" + authMode + "', password='" + password + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerAuthenticationMode that = (SetCustomerAuthenticationMode) o;
    return Objects.equals(authMode, that.authMode) &&
        Objects.equals(password, that.password);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authMode, password);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private AuthenticationMode authMode;

    private String password;

    public SetCustomerAuthenticationMode build() {
      SetCustomerAuthenticationMode result = new SetCustomerAuthenticationMode();
      result.authMode = this.authMode;
      result.password = this.password;
      return result;
    }

    public Builder authMode(AuthenticationMode authMode) {
      this.authMode = authMode;
      return this;
    }

    public Builder password(String password) {
      this.password = password;
      return this;
    }
  }
}
