package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerCompanyName {
  private String companyName;

  public SetCustomerCompanyName() {
  }

  public SetCustomerCompanyName(String companyName) {
    this.companyName = companyName;
  }

  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @Override
  public String toString() {
    return "SetCustomerCompanyName{companyName='" + companyName + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerCompanyName that = (SetCustomerCompanyName) o;
    return Objects.equals(companyName, that.companyName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyName);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String companyName;

    public SetCustomerCompanyName build() {
      SetCustomerCompanyName result = new SetCustomerCompanyName();
      result.companyName = this.companyName;
      return result;
    }

    public Builder companyName(String companyName) {
      this.companyName = companyName;
      return this;
    }
  }
}
