package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.LocalDate;
import java.util.Objects;

public class SetCustomerDateOfBirth {
  private LocalDate dateOfBirth;

  public SetCustomerDateOfBirth() {
  }

  public SetCustomerDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  public LocalDate getDateOfBirth() {
    return dateOfBirth;
  }

  public void setDateOfBirth(LocalDate dateOfBirth) {
    this.dateOfBirth = dateOfBirth;
  }

  @Override
  public String toString() {
    return "SetCustomerDateOfBirth{dateOfBirth='" + dateOfBirth + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerDateOfBirth that = (SetCustomerDateOfBirth) o;
    return Objects.equals(dateOfBirth, that.dateOfBirth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dateOfBirth);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private LocalDate dateOfBirth;

    public SetCustomerDateOfBirth build() {
      SetCustomerDateOfBirth result = new SetCustomerDateOfBirth();
      result.dateOfBirth = this.dateOfBirth;
      return result;
    }

    public Builder dateOfBirth(LocalDate dateOfBirth) {
      this.dateOfBirth = dateOfBirth;
      return this;
    }
  }
}
