package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerGroup {
  private ResourceIdentifierInput customerGroup;

  public SetCustomerGroup() {
  }

  public SetCustomerGroup(ResourceIdentifierInput customerGroup) {
    this.customerGroup = customerGroup;
  }

  public ResourceIdentifierInput getCustomerGroup() {
    return customerGroup;
  }

  public void setCustomerGroup(ResourceIdentifierInput customerGroup) {
    this.customerGroup = customerGroup;
  }

  @Override
  public String toString() {
    return "SetCustomerGroup{customerGroup='" + customerGroup + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerGroup that = (SetCustomerGroup) o;
    return Objects.equals(customerGroup, that.customerGroup);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerGroup);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput customerGroup;

    public SetCustomerGroup build() {
      SetCustomerGroup result = new SetCustomerGroup();
      result.customerGroup = this.customerGroup;
      return result;
    }

    public Builder customerGroup(ResourceIdentifierInput customerGroup) {
      this.customerGroup = customerGroup;
      return this;
    }
  }
}
