package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

/**
 * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
 */
public class SetCustomerGroupAssignments {
  private List<CustomerGroupAssignmentDraft> customerGroupAssignments;

  public SetCustomerGroupAssignments() {
  }

  public SetCustomerGroupAssignments(List<CustomerGroupAssignmentDraft> customerGroupAssignments) {
    this.customerGroupAssignments = customerGroupAssignments;
  }

  public List<CustomerGroupAssignmentDraft> getCustomerGroupAssignments() {
    return customerGroupAssignments;
  }

  public void setCustomerGroupAssignments(
      List<CustomerGroupAssignmentDraft> customerGroupAssignments) {
    this.customerGroupAssignments = customerGroupAssignments;
  }

  @Override
  public String toString() {
    return "SetCustomerGroupAssignments{customerGroupAssignments='" + customerGroupAssignments + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerGroupAssignments that = (SetCustomerGroupAssignments) o;
    return Objects.equals(customerGroupAssignments, that.customerGroupAssignments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerGroupAssignments);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<CustomerGroupAssignmentDraft> customerGroupAssignments;

    public SetCustomerGroupAssignments build() {
      SetCustomerGroupAssignments result = new SetCustomerGroupAssignments();
      result.customerGroupAssignments = this.customerGroupAssignments;
      return result;
    }

    public Builder customerGroupAssignments(
        List<CustomerGroupAssignmentDraft> customerGroupAssignments) {
      this.customerGroupAssignments = customerGroupAssignments;
      return this;
    }
  }
}
