package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerLocale {
  private String locale;

  public SetCustomerLocale() {
  }

  public SetCustomerLocale(String locale) {
    this.locale = locale;
  }

  public String getLocale() {
    return locale;
  }

  public void setLocale(String locale) {
    this.locale = locale;
  }

  @Override
  public String toString() {
    return "SetCustomerLocale{locale='" + locale + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerLocale that = (SetCustomerLocale) o;
    return Objects.equals(locale, that.locale);
  }

  @Override
  public int hashCode() {
    return Objects.hash(locale);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String locale;

    public SetCustomerLocale build() {
      SetCustomerLocale result = new SetCustomerLocale();
      result.locale = this.locale;
      return result;
    }

    public Builder locale(String locale) {
      this.locale = locale;
      return this;
    }
  }
}
