package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerMiddleName {
  private String middleName;

  public SetCustomerMiddleName() {
  }

  public SetCustomerMiddleName(String middleName) {
    this.middleName = middleName;
  }

  public String getMiddleName() {
    return middleName;
  }

  public void setMiddleName(String middleName) {
    this.middleName = middleName;
  }

  @Override
  public String toString() {
    return "SetCustomerMiddleName{middleName='" + middleName + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerMiddleName that = (SetCustomerMiddleName) o;
    return Objects.equals(middleName, that.middleName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(middleName);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String middleName;

    public SetCustomerMiddleName build() {
      SetCustomerMiddleName result = new SetCustomerMiddleName();
      result.middleName = this.middleName;
      return result;
    }

    public Builder middleName(String middleName) {
      this.middleName = middleName;
      return this;
    }
  }
}
