package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetCustomerNumber {
  private String customerNumber;

  public SetCustomerNumber() {
  }

  public SetCustomerNumber(String customerNumber) {
    this.customerNumber = customerNumber;
  }

  public String getCustomerNumber() {
    return customerNumber;
  }

  public void setCustomerNumber(String customerNumber) {
    this.customerNumber = customerNumber;
  }

  @Override
  public String toString() {
    return "SetCustomerNumber{customerNumber='" + customerNumber + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerNumber that = (SetCustomerNumber) o;
    return Objects.equals(customerNumber, that.customerNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerNumber);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customerNumber;

    public SetCustomerNumber build() {
      SetCustomerNumber result = new SetCustomerNumber();
      result.customerNumber = this.customerNumber;
      return result;
    }

    public Builder customerNumber(String customerNumber) {
      this.customerNumber = customerNumber;
      return this;
    }
  }
}
