package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetCustomerStores {
  private List<ResourceIdentifierInput> stores;

  public SetCustomerStores() {
  }

  public SetCustomerStores(List<ResourceIdentifierInput> stores) {
    this.stores = stores;
  }

  public List<ResourceIdentifierInput> getStores() {
    return stores;
  }

  public void setStores(List<ResourceIdentifierInput> stores) {
    this.stores = stores;
  }

  @Override
  public String toString() {
    return "SetCustomerStores{stores='" + stores + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetCustomerStores that = (SetCustomerStores) o;
    return Objects.equals(stores, that.stores);
  }

  @Override
  public int hashCode() {
    return Objects.hash(stores);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<ResourceIdentifierInput> stores;

    public SetCustomerStores build() {
      SetCustomerStores result = new SetCustomerStores();
      result.stores = this.stores;
      return result;
    }

    public Builder stores(List<ResourceIdentifierInput> stores) {
      this.stores = stores;
      return this;
    }
  }
}
