package com.commercetools.graphql.api.types;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetDiscountCodeMaxApplications {
  private Long maxApplications;

  public SetDiscountCodeMaxApplications() {
  }

  public SetDiscountCodeMaxApplications(Long maxApplications) {
    this.maxApplications = maxApplications;
  }

  public Long getMaxApplications() {
    return maxApplications;
  }

  public void setMaxApplications(Long maxApplications) {
    this.maxApplications = maxApplications;
  }

  @Override
  public String toString() {
    return "SetDiscountCodeMaxApplications{maxApplications='" + maxApplications + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetDiscountCodeMaxApplications that = (SetDiscountCodeMaxApplications) o;
    return Objects.equals(maxApplications, that.maxApplications);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maxApplications);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Long maxApplications;

    public SetDiscountCodeMaxApplications build() {
      SetDiscountCodeMaxApplications result = new SetDiscountCodeMaxApplications();
      result.maxApplications = this.maxApplications;
      return result;
    }

    public Builder maxApplications(Long maxApplications) {
      this.maxApplications = maxApplications;
      return this;
    }
  }
}
