package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetInventoryEntryCustomType {
  private String typeId;

  private String typeKey;

  private ResourceIdentifierInput type;

  private List<CustomFieldInput> fields;

  public SetInventoryEntryCustomType() {
  }

  public SetInventoryEntryCustomType(String typeId, String typeKey, ResourceIdentifierInput type,
      List<CustomFieldInput> fields) {
    this.typeId = typeId;
    this.typeKey = typeKey;
    this.type = type;
    this.fields = fields;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getTypeKey() {
    return typeKey;
  }

  public void setTypeKey(String typeKey) {
    this.typeKey = typeKey;
  }

  public ResourceIdentifierInput getType() {
    return type;
  }

  public void setType(ResourceIdentifierInput type) {
    this.type = type;
  }

  public List<CustomFieldInput> getFields() {
    return fields;
  }

  public void setFields(List<CustomFieldInput> fields) {
    this.fields = fields;
  }

  @Override
  public String toString() {
    return "SetInventoryEntryCustomType{typeId='" + typeId + "', typeKey='" + typeKey + "', type='" + type + "', fields='" + fields + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetInventoryEntryCustomType that = (SetInventoryEntryCustomType) o;
    return Objects.equals(typeId, that.typeId) &&
        Objects.equals(typeKey, that.typeKey) &&
        Objects.equals(type, that.type) &&
        Objects.equals(fields, that.fields);
  }

  @Override
  public int hashCode() {
    return Objects.hash(typeId, typeKey, type, fields);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String typeId;

    private String typeKey;

    private ResourceIdentifierInput type;

    private List<CustomFieldInput> fields;

    public SetInventoryEntryCustomType build() {
      SetInventoryEntryCustomType result = new SetInventoryEntryCustomType();
      result.typeId = this.typeId;
      result.typeKey = this.typeKey;
      result.type = this.type;
      result.fields = this.fields;
      return result;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder typeKey(String typeKey) {
      this.typeKey = typeKey;
      return this;
    }

    public Builder type(ResourceIdentifierInput type) {
      this.type = type;
      return this;
    }

    public Builder fields(List<CustomFieldInput> fields) {
      this.fields = fields;
      return this;
    }
  }
}
