package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetInventoryEntryRestockableInDays {
  private Integer restockableInDays;

  public SetInventoryEntryRestockableInDays() {
  }

  public SetInventoryEntryRestockableInDays(Integer restockableInDays) {
    this.restockableInDays = restockableInDays;
  }

  public Integer getRestockableInDays() {
    return restockableInDays;
  }

  public void setRestockableInDays(Integer restockableInDays) {
    this.restockableInDays = restockableInDays;
  }

  @Override
  public String toString() {
    return "SetInventoryEntryRestockableInDays{restockableInDays='" + restockableInDays + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetInventoryEntryRestockableInDays that = (SetInventoryEntryRestockableInDays) o;
    return Objects.equals(restockableInDays, that.restockableInDays);
  }

  @Override
  public int hashCode() {
    return Objects.hash(restockableInDays);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer restockableInDays;

    public SetInventoryEntryRestockableInDays build() {
      SetInventoryEntryRestockableInDays result = new SetInventoryEntryRestockableInDays();
      result.restockableInDays = this.restockableInDays;
      return result;
    }

    public Builder restockableInDays(Integer restockableInDays) {
      this.restockableInDays = restockableInDays;
      return this;
    }
  }
}
