package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetMyBusinessUnitAddressCustomType {
  private String addressId;

  private String addressKey;

  private List<CustomFieldInput> fields;

  private ResourceIdentifierInput type;

  private String typeKey;

  private String typeId;

  public SetMyBusinessUnitAddressCustomType() {
  }

  public SetMyBusinessUnitAddressCustomType(String addressId, String addressKey,
      List<CustomFieldInput> fields, ResourceIdentifierInput type, String typeKey, String typeId) {
    this.addressId = addressId;
    this.addressKey = addressKey;
    this.fields = fields;
    this.type = type;
    this.typeKey = typeKey;
    this.typeId = typeId;
  }

  public String getAddressId() {
    return addressId;
  }

  public void setAddressId(String addressId) {
    this.addressId = addressId;
  }

  public String getAddressKey() {
    return addressKey;
  }

  public void setAddressKey(String addressKey) {
    this.addressKey = addressKey;
  }

  public List<CustomFieldInput> getFields() {
    return fields;
  }

  public void setFields(List<CustomFieldInput> fields) {
    this.fields = fields;
  }

  public ResourceIdentifierInput getType() {
    return type;
  }

  public void setType(ResourceIdentifierInput type) {
    this.type = type;
  }

  public String getTypeKey() {
    return typeKey;
  }

  public void setTypeKey(String typeKey) {
    this.typeKey = typeKey;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  @Override
  public String toString() {
    return "SetMyBusinessUnitAddressCustomType{addressId='" + addressId + "', addressKey='" + addressKey + "', fields='" + fields + "', type='" + type + "', typeKey='" + typeKey + "', typeId='" + typeId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetMyBusinessUnitAddressCustomType that = (SetMyBusinessUnitAddressCustomType) o;
    return Objects.equals(addressId, that.addressId) &&
        Objects.equals(addressKey, that.addressKey) &&
        Objects.equals(fields, that.fields) &&
        Objects.equals(type, that.type) &&
        Objects.equals(typeKey, that.typeKey) &&
        Objects.equals(typeId, that.typeId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressId, addressKey, fields, type, typeKey, typeId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String addressId;

    private String addressKey;

    private List<CustomFieldInput> fields;

    private ResourceIdentifierInput type;

    private String typeKey;

    private String typeId;

    public SetMyBusinessUnitAddressCustomType build() {
      SetMyBusinessUnitAddressCustomType result = new SetMyBusinessUnitAddressCustomType();
      result.addressId = this.addressId;
      result.addressKey = this.addressKey;
      result.fields = this.fields;
      result.type = this.type;
      result.typeKey = this.typeKey;
      result.typeId = this.typeId;
      return result;
    }

    public Builder addressId(String addressId) {
      this.addressId = addressId;
      return this;
    }

    public Builder addressKey(String addressKey) {
      this.addressKey = addressKey;
      return this;
    }

    public Builder fields(List<CustomFieldInput> fields) {
      this.fields = fields;
      return this;
    }

    public Builder type(ResourceIdentifierInput type) {
      this.type = type;
      return this;
    }

    public Builder typeKey(String typeKey) {
      this.typeKey = typeKey;
      return this;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }
  }
}
