package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetMyBusinessUnitContactEmail {
  private String contactEmail;

  public SetMyBusinessUnitContactEmail() {
  }

  public SetMyBusinessUnitContactEmail(String contactEmail) {
    this.contactEmail = contactEmail;
  }

  public String getContactEmail() {
    return contactEmail;
  }

  public void setContactEmail(String contactEmail) {
    this.contactEmail = contactEmail;
  }

  @Override
  public String toString() {
    return "SetMyBusinessUnitContactEmail{contactEmail='" + contactEmail + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetMyBusinessUnitContactEmail that = (SetMyBusinessUnitContactEmail) o;
    return Objects.equals(contactEmail, that.contactEmail);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contactEmail);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String contactEmail;

    public SetMyBusinessUnitContactEmail build() {
      SetMyBusinessUnitContactEmail result = new SetMyBusinessUnitContactEmail();
      result.contactEmail = this.contactEmail;
      return result;
    }

    public Builder contactEmail(String contactEmail) {
      this.contactEmail = contactEmail;
      return this;
    }
  }
}
