package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderBusinessUnit {
  private ResourceIdentifierInput businessUnit;

  public SetOrderBusinessUnit() {
  }

  public SetOrderBusinessUnit(ResourceIdentifierInput businessUnit) {
    this.businessUnit = businessUnit;
  }

  public ResourceIdentifierInput getBusinessUnit() {
    return businessUnit;
  }

  public void setBusinessUnit(ResourceIdentifierInput businessUnit) {
    this.businessUnit = businessUnit;
  }

  @Override
  public String toString() {
    return "SetOrderBusinessUnit{businessUnit='" + businessUnit + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderBusinessUnit that = (SetOrderBusinessUnit) o;
    return Objects.equals(businessUnit, that.businessUnit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessUnit);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput businessUnit;

    public SetOrderBusinessUnit build() {
      SetOrderBusinessUnit result = new SetOrderBusinessUnit();
      result.businessUnit = this.businessUnit;
      return result;
    }

    public Builder businessUnit(ResourceIdentifierInput businessUnit) {
      this.businessUnit = businessUnit;
      return this;
    }
  }
}
