package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderCustomLineItemShippingDetails {
  private String customLineItemId;

  private String customLineItemKey;

  private ItemShippingDetailsDraftType shippingDetails;

  public SetOrderCustomLineItemShippingDetails() {
  }

  public SetOrderCustomLineItemShippingDetails(String customLineItemId, String customLineItemKey,
      ItemShippingDetailsDraftType shippingDetails) {
    this.customLineItemId = customLineItemId;
    this.customLineItemKey = customLineItemKey;
    this.shippingDetails = shippingDetails;
  }

  public String getCustomLineItemId() {
    return customLineItemId;
  }

  public void setCustomLineItemId(String customLineItemId) {
    this.customLineItemId = customLineItemId;
  }

  public String getCustomLineItemKey() {
    return customLineItemKey;
  }

  public void setCustomLineItemKey(String customLineItemKey) {
    this.customLineItemKey = customLineItemKey;
  }

  public ItemShippingDetailsDraftType getShippingDetails() {
    return shippingDetails;
  }

  public void setShippingDetails(ItemShippingDetailsDraftType shippingDetails) {
    this.shippingDetails = shippingDetails;
  }

  @Override
  public String toString() {
    return "SetOrderCustomLineItemShippingDetails{customLineItemId='" + customLineItemId + "', customLineItemKey='" + customLineItemKey + "', shippingDetails='" + shippingDetails + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderCustomLineItemShippingDetails that = (SetOrderCustomLineItemShippingDetails) o;
    return Objects.equals(customLineItemId, that.customLineItemId) &&
        Objects.equals(customLineItemKey, that.customLineItemKey) &&
        Objects.equals(shippingDetails, that.shippingDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customLineItemId, customLineItemKey, shippingDetails);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customLineItemId;

    private String customLineItemKey;

    private ItemShippingDetailsDraftType shippingDetails;

    public SetOrderCustomLineItemShippingDetails build() {
      SetOrderCustomLineItemShippingDetails result = new SetOrderCustomLineItemShippingDetails();
      result.customLineItemId = this.customLineItemId;
      result.customLineItemKey = this.customLineItemKey;
      result.shippingDetails = this.shippingDetails;
      return result;
    }

    public Builder customLineItemId(String customLineItemId) {
      this.customLineItemId = customLineItemId;
      return this;
    }

    public Builder customLineItemKey(String customLineItemKey) {
      this.customLineItemKey = customLineItemKey;
      return this;
    }

    public Builder shippingDetails(ItemShippingDetailsDraftType shippingDetails) {
      this.shippingDetails = shippingDetails;
      return this;
    }
  }
}
