package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderCustomerId {
  private String customerId;

  public SetOrderCustomerId() {
  }

  public SetOrderCustomerId(String customerId) {
    this.customerId = customerId;
  }

  public String getCustomerId() {
    return customerId;
  }

  public void setCustomerId(String customerId) {
    this.customerId = customerId;
  }

  @Override
  public String toString() {
    return "SetOrderCustomerId{customerId='" + customerId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderCustomerId that = (SetOrderCustomerId) o;
    return Objects.equals(customerId, that.customerId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customerId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String customerId;

    public SetOrderCustomerId build() {
      SetOrderCustomerId result = new SetOrderCustomerId();
      result.customerId = this.customerId;
      return result;
    }

    public Builder customerId(String customerId) {
      this.customerId = customerId;
      return this;
    }
  }
}
