package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderDeliveryAddress {
  private String deliveryId;

  private String deliveryKey;

  private AddressInput address;

  public SetOrderDeliveryAddress() {
  }

  public SetOrderDeliveryAddress(String deliveryId, String deliveryKey, AddressInput address) {
    this.deliveryId = deliveryId;
    this.deliveryKey = deliveryKey;
    this.address = address;
  }

  public String getDeliveryId() {
    return deliveryId;
  }

  public void setDeliveryId(String deliveryId) {
    this.deliveryId = deliveryId;
  }

  public String getDeliveryKey() {
    return deliveryKey;
  }

  public void setDeliveryKey(String deliveryKey) {
    this.deliveryKey = deliveryKey;
  }

  public AddressInput getAddress() {
    return address;
  }

  public void setAddress(AddressInput address) {
    this.address = address;
  }

  @Override
  public String toString() {
    return "SetOrderDeliveryAddress{deliveryId='" + deliveryId + "', deliveryKey='" + deliveryKey + "', address='" + address + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderDeliveryAddress that = (SetOrderDeliveryAddress) o;
    return Objects.equals(deliveryId, that.deliveryId) &&
        Objects.equals(deliveryKey, that.deliveryKey) &&
        Objects.equals(address, that.address);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deliveryId, deliveryKey, address);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String deliveryId;

    private String deliveryKey;

    private AddressInput address;

    public SetOrderDeliveryAddress build() {
      SetOrderDeliveryAddress result = new SetOrderDeliveryAddress();
      result.deliveryId = this.deliveryId;
      result.deliveryKey = this.deliveryKey;
      result.address = this.address;
      return result;
    }

    public Builder deliveryId(String deliveryId) {
      this.deliveryId = deliveryId;
      return this;
    }

    public Builder deliveryKey(String deliveryKey) {
      this.deliveryKey = deliveryKey;
      return this;
    }

    public Builder address(AddressInput address) {
      this.address = address;
      return this;
    }
  }
}
