package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetOrderLineItemCustomType {
  private String lineItemId;

  private List<CustomFieldInput> fields;

  private ResourceIdentifierInput type;

  private String typeKey;

  private String typeId;

  private String lineItemKey;

  public SetOrderLineItemCustomType() {
  }

  public SetOrderLineItemCustomType(String lineItemId, List<CustomFieldInput> fields,
      ResourceIdentifierInput type, String typeKey, String typeId, String lineItemKey) {
    this.lineItemId = lineItemId;
    this.fields = fields;
    this.type = type;
    this.typeKey = typeKey;
    this.typeId = typeId;
    this.lineItemKey = lineItemKey;
  }

  public String getLineItemId() {
    return lineItemId;
  }

  public void setLineItemId(String lineItemId) {
    this.lineItemId = lineItemId;
  }

  public List<CustomFieldInput> getFields() {
    return fields;
  }

  public void setFields(List<CustomFieldInput> fields) {
    this.fields = fields;
  }

  public ResourceIdentifierInput getType() {
    return type;
  }

  public void setType(ResourceIdentifierInput type) {
    this.type = type;
  }

  public String getTypeKey() {
    return typeKey;
  }

  public void setTypeKey(String typeKey) {
    this.typeKey = typeKey;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getLineItemKey() {
    return lineItemKey;
  }

  public void setLineItemKey(String lineItemKey) {
    this.lineItemKey = lineItemKey;
  }

  @Override
  public String toString() {
    return "SetOrderLineItemCustomType{lineItemId='" + lineItemId + "', fields='" + fields + "', type='" + type + "', typeKey='" + typeKey + "', typeId='" + typeId + "', lineItemKey='" + lineItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderLineItemCustomType that = (SetOrderLineItemCustomType) o;
    return Objects.equals(lineItemId, that.lineItemId) &&
        Objects.equals(fields, that.fields) &&
        Objects.equals(type, that.type) &&
        Objects.equals(typeKey, that.typeKey) &&
        Objects.equals(typeId, that.typeId) &&
        Objects.equals(lineItemKey, that.lineItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(lineItemId, fields, type, typeKey, typeId, lineItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String lineItemId;

    private List<CustomFieldInput> fields;

    private ResourceIdentifierInput type;

    private String typeKey;

    private String typeId;

    private String lineItemKey;

    public SetOrderLineItemCustomType build() {
      SetOrderLineItemCustomType result = new SetOrderLineItemCustomType();
      result.lineItemId = this.lineItemId;
      result.fields = this.fields;
      result.type = this.type;
      result.typeKey = this.typeKey;
      result.typeId = this.typeId;
      result.lineItemKey = this.lineItemKey;
      return result;
    }

    public Builder lineItemId(String lineItemId) {
      this.lineItemId = lineItemId;
      return this;
    }

    public Builder fields(List<CustomFieldInput> fields) {
      this.fields = fields;
      return this;
    }

    public Builder type(ResourceIdentifierInput type) {
      this.type = type;
      return this;
    }

    public Builder typeKey(String typeKey) {
      this.typeKey = typeKey;
      return this;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder lineItemKey(String lineItemKey) {
      this.lineItemKey = lineItemKey;
      return this;
    }
  }
}
