package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderNumber {
  private String orderNumber;

  public SetOrderNumber() {
  }

  public SetOrderNumber(String orderNumber) {
    this.orderNumber = orderNumber;
  }

  public String getOrderNumber() {
    return orderNumber;
  }

  public void setOrderNumber(String orderNumber) {
    this.orderNumber = orderNumber;
  }

  @Override
  public String toString() {
    return "SetOrderNumber{orderNumber='" + orderNumber + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderNumber that = (SetOrderNumber) o;
    return Objects.equals(orderNumber, that.orderNumber);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orderNumber);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String orderNumber;

    public SetOrderNumber build() {
      SetOrderNumber result = new SetOrderNumber();
      result.orderNumber = this.orderNumber;
      return result;
    }

    public Builder orderNumber(String orderNumber) {
      this.orderNumber = orderNumber;
      return this;
    }
  }
}
