package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderParcelCustomField {
  private String name;

  private String value;

  private String parcelId;

  private String parcelKey;

  public SetOrderParcelCustomField() {
  }

  public SetOrderParcelCustomField(String name, String value, String parcelId, String parcelKey) {
    this.name = name;
    this.value = value;
    this.parcelId = parcelId;
    this.parcelKey = parcelKey;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getParcelId() {
    return parcelId;
  }

  public void setParcelId(String parcelId) {
    this.parcelId = parcelId;
  }

  public String getParcelKey() {
    return parcelKey;
  }

  public void setParcelKey(String parcelKey) {
    this.parcelKey = parcelKey;
  }

  @Override
  public String toString() {
    return "SetOrderParcelCustomField{name='" + name + "', value='" + value + "', parcelId='" + parcelId + "', parcelKey='" + parcelKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderParcelCustomField that = (SetOrderParcelCustomField) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(parcelId, that.parcelId) &&
        Objects.equals(parcelKey, that.parcelKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, value, parcelId, parcelKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private String value;

    private String parcelId;

    private String parcelKey;

    public SetOrderParcelCustomField build() {
      SetOrderParcelCustomField result = new SetOrderParcelCustomField();
      result.name = this.name;
      result.value = this.value;
      result.parcelId = this.parcelId;
      result.parcelKey = this.parcelKey;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder parcelId(String parcelId) {
      this.parcelId = parcelId;
      return this;
    }

    public Builder parcelKey(String parcelKey) {
      this.parcelKey = parcelKey;
      return this;
    }
  }
}
