package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetOrderReturnItemCustomType {
  private List<CustomFieldInput> fields;

  private ResourceIdentifierInput type;

  private String typeKey;

  private String typeId;

  private String returnItemId;

  private String returnItemKey;

  public SetOrderReturnItemCustomType() {
  }

  public SetOrderReturnItemCustomType(List<CustomFieldInput> fields, ResourceIdentifierInput type,
      String typeKey, String typeId, String returnItemId, String returnItemKey) {
    this.fields = fields;
    this.type = type;
    this.typeKey = typeKey;
    this.typeId = typeId;
    this.returnItemId = returnItemId;
    this.returnItemKey = returnItemKey;
  }

  public List<CustomFieldInput> getFields() {
    return fields;
  }

  public void setFields(List<CustomFieldInput> fields) {
    this.fields = fields;
  }

  public ResourceIdentifierInput getType() {
    return type;
  }

  public void setType(ResourceIdentifierInput type) {
    this.type = type;
  }

  public String getTypeKey() {
    return typeKey;
  }

  public void setTypeKey(String typeKey) {
    this.typeKey = typeKey;
  }

  public String getTypeId() {
    return typeId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public String getReturnItemId() {
    return returnItemId;
  }

  public void setReturnItemId(String returnItemId) {
    this.returnItemId = returnItemId;
  }

  public String getReturnItemKey() {
    return returnItemKey;
  }

  public void setReturnItemKey(String returnItemKey) {
    this.returnItemKey = returnItemKey;
  }

  @Override
  public String toString() {
    return "SetOrderReturnItemCustomType{fields='" + fields + "', type='" + type + "', typeKey='" + typeKey + "', typeId='" + typeId + "', returnItemId='" + returnItemId + "', returnItemKey='" + returnItemKey + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderReturnItemCustomType that = (SetOrderReturnItemCustomType) o;
    return Objects.equals(fields, that.fields) &&
        Objects.equals(type, that.type) &&
        Objects.equals(typeKey, that.typeKey) &&
        Objects.equals(typeId, that.typeId) &&
        Objects.equals(returnItemId, that.returnItemId) &&
        Objects.equals(returnItemKey, that.returnItemKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fields, type, typeKey, typeId, returnItemId, returnItemKey);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<CustomFieldInput> fields;

    private ResourceIdentifierInput type;

    private String typeKey;

    private String typeId;

    private String returnItemId;

    private String returnItemKey;

    public SetOrderReturnItemCustomType build() {
      SetOrderReturnItemCustomType result = new SetOrderReturnItemCustomType();
      result.fields = this.fields;
      result.type = this.type;
      result.typeKey = this.typeKey;
      result.typeId = this.typeId;
      result.returnItemId = this.returnItemId;
      result.returnItemKey = this.returnItemKey;
      return result;
    }

    public Builder fields(List<CustomFieldInput> fields) {
      this.fields = fields;
      return this;
    }

    public Builder type(ResourceIdentifierInput type) {
      this.type = type;
      return this;
    }

    public Builder typeKey(String typeKey) {
      this.typeKey = typeKey;
      return this;
    }

    public Builder typeId(String typeId) {
      this.typeId = typeId;
      return this;
    }

    public Builder returnItemId(String returnItemId) {
      this.returnItemId = returnItemId;
      return this;
    }

    public Builder returnItemKey(String returnItemKey) {
      this.returnItemKey = returnItemKey;
      return this;
    }
  }
}
