package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetOrderReturnShipmentState {
  private String returnItemId;

  private String returnItemKey;

  private ReturnShipmentState shipmentState;

  public SetOrderReturnShipmentState() {
  }

  public SetOrderReturnShipmentState(String returnItemId, String returnItemKey,
      ReturnShipmentState shipmentState) {
    this.returnItemId = returnItemId;
    this.returnItemKey = returnItemKey;
    this.shipmentState = shipmentState;
  }

  public String getReturnItemId() {
    return returnItemId;
  }

  public void setReturnItemId(String returnItemId) {
    this.returnItemId = returnItemId;
  }

  public String getReturnItemKey() {
    return returnItemKey;
  }

  public void setReturnItemKey(String returnItemKey) {
    this.returnItemKey = returnItemKey;
  }

  public ReturnShipmentState getShipmentState() {
    return shipmentState;
  }

  public void setShipmentState(ReturnShipmentState shipmentState) {
    this.shipmentState = shipmentState;
  }

  @Override
  public String toString() {
    return "SetOrderReturnShipmentState{returnItemId='" + returnItemId + "', returnItemKey='" + returnItemKey + "', shipmentState='" + shipmentState + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetOrderReturnShipmentState that = (SetOrderReturnShipmentState) o;
    return Objects.equals(returnItemId, that.returnItemId) &&
        Objects.equals(returnItemKey, that.returnItemKey) &&
        Objects.equals(shipmentState, that.shipmentState);
  }

  @Override
  public int hashCode() {
    return Objects.hash(returnItemId, returnItemKey, shipmentState);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String returnItemId;

    private String returnItemKey;

    private ReturnShipmentState shipmentState;

    public SetOrderReturnShipmentState build() {
      SetOrderReturnShipmentState result = new SetOrderReturnShipmentState();
      result.returnItemId = this.returnItemId;
      result.returnItemKey = this.returnItemKey;
      result.shipmentState = this.shipmentState;
      return result;
    }

    public Builder returnItemId(String returnItemId) {
      this.returnItemId = returnItemId;
      return this;
    }

    public Builder returnItemKey(String returnItemKey) {
      this.returnItemKey = returnItemKey;
      return this;
    }

    public Builder shipmentState(ReturnShipmentState shipmentState) {
      this.shipmentState = shipmentState;
      return this;
    }
  }
}
