package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetPaymentAmountRefunded {
  private MoneyInput amount;

  public SetPaymentAmountRefunded() {
  }

  public SetPaymentAmountRefunded(MoneyInput amount) {
    this.amount = amount;
  }

  public MoneyInput getAmount() {
    return amount;
  }

  public void setAmount(MoneyInput amount) {
    this.amount = amount;
  }

  @Override
  public String toString() {
    return "SetPaymentAmountRefunded{amount='" + amount + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetPaymentAmountRefunded that = (SetPaymentAmountRefunded) o;
    return Objects.equals(amount, that.amount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoneyInput amount;

    public SetPaymentAmountRefunded build() {
      SetPaymentAmountRefunded result = new SetPaymentAmountRefunded();
      result.amount = this.amount;
      return result;
    }

    public Builder amount(MoneyInput amount) {
      this.amount = amount;
      return this;
    }
  }
}
