package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SetPaymentAuthorization {
  private MoneyInput amount;

  private OffsetDateTime until;

  public SetPaymentAuthorization() {
  }

  public SetPaymentAuthorization(MoneyInput amount, OffsetDateTime until) {
    this.amount = amount;
    this.until = until;
  }

  public MoneyInput getAmount() {
    return amount;
  }

  public void setAmount(MoneyInput amount) {
    this.amount = amount;
  }

  public OffsetDateTime getUntil() {
    return until;
  }

  public void setUntil(OffsetDateTime until) {
    this.until = until;
  }

  @Override
  public String toString() {
    return "SetPaymentAuthorization{amount='" + amount + "', until='" + until + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetPaymentAuthorization that = (SetPaymentAuthorization) o;
    return Objects.equals(amount, that.amount) &&
        Objects.equals(until, that.until);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, until);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoneyInput amount;

    private OffsetDateTime until;

    public SetPaymentAuthorization build() {
      SetPaymentAuthorization result = new SetPaymentAuthorization();
      result.amount = this.amount;
      result.until = this.until;
      return result;
    }

    public Builder amount(MoneyInput amount) {
      this.amount = amount;
      return this;
    }

    public Builder until(OffsetDateTime until) {
      this.until = until;
      return this;
    }
  }
}
