package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetPaymentInterfaceId {
  private String interfaceId;

  public SetPaymentInterfaceId() {
  }

  public SetPaymentInterfaceId(String interfaceId) {
    this.interfaceId = interfaceId;
  }

  public String getInterfaceId() {
    return interfaceId;
  }

  public void setInterfaceId(String interfaceId) {
    this.interfaceId = interfaceId;
  }

  @Override
  public String toString() {
    return "SetPaymentInterfaceId{interfaceId='" + interfaceId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetPaymentInterfaceId that = (SetPaymentInterfaceId) o;
    return Objects.equals(interfaceId, that.interfaceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(interfaceId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String interfaceId;

    public SetPaymentInterfaceId build() {
      SetPaymentInterfaceId result = new SetPaymentInterfaceId();
      result.interfaceId = this.interfaceId;
      return result;
    }

    public Builder interfaceId(String interfaceId) {
      this.interfaceId = interfaceId;
      return this;
    }
  }
}
