package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetPaymentMethodInfoMethod {
  private String method;

  public SetPaymentMethodInfoMethod() {
  }

  public SetPaymentMethodInfoMethod(String method) {
    this.method = method;
  }

  public String getMethod() {
    return method;
  }

  public void setMethod(String method) {
    this.method = method;
  }

  @Override
  public String toString() {
    return "SetPaymentMethodInfoMethod{method='" + method + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetPaymentMethodInfoMethod that = (SetPaymentMethodInfoMethod) o;
    return Objects.equals(method, that.method);
  }

  @Override
  public int hashCode() {
    return Objects.hash(method);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String method;

    public SetPaymentMethodInfoMethod build() {
      SetPaymentMethodInfoMethod result = new SetPaymentMethodInfoMethod();
      result.method = this.method;
      return result;
    }

    public Builder method(String method) {
      this.method = method;
      return this;
    }
  }
}
