package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetPaymentStatusInterfaceCode {
  private String interfaceCode;

  public SetPaymentStatusInterfaceCode() {
  }

  public SetPaymentStatusInterfaceCode(String interfaceCode) {
    this.interfaceCode = interfaceCode;
  }

  public String getInterfaceCode() {
    return interfaceCode;
  }

  public void setInterfaceCode(String interfaceCode) {
    this.interfaceCode = interfaceCode;
  }

  @Override
  public String toString() {
    return "SetPaymentStatusInterfaceCode{interfaceCode='" + interfaceCode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetPaymentStatusInterfaceCode that = (SetPaymentStatusInterfaceCode) o;
    return Objects.equals(interfaceCode, that.interfaceCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(interfaceCode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String interfaceCode;

    public SetPaymentStatusInterfaceCode build() {
      SetPaymentStatusInterfaceCode result = new SetPaymentStatusInterfaceCode();
      result.interfaceCode = this.interfaceCode;
      return result;
    }

    public Builder interfaceCode(String interfaceCode) {
      this.interfaceCode = interfaceCode;
      return this;
    }
  }
}
