package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetPaymentStatusInterfaceText {
  private String interfaceText;

  public SetPaymentStatusInterfaceText() {
  }

  public SetPaymentStatusInterfaceText(String interfaceText) {
    this.interfaceText = interfaceText;
  }

  public String getInterfaceText() {
    return interfaceText;
  }

  public void setInterfaceText(String interfaceText) {
    this.interfaceText = interfaceText;
  }

  @Override
  public String toString() {
    return "SetPaymentStatusInterfaceText{interfaceText='" + interfaceText + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetPaymentStatusInterfaceText that = (SetPaymentStatusInterfaceText) o;
    return Objects.equals(interfaceText, that.interfaceText);
  }

  @Override
  public int hashCode() {
    return Objects.hash(interfaceText);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String interfaceText;

    public SetPaymentStatusInterfaceText build() {
      SetPaymentStatusInterfaceText result = new SetPaymentStatusInterfaceText();
      result.interfaceText = this.interfaceText;
      return result;
    }

    public Builder interfaceText(String interfaceText) {
      this.interfaceText = interfaceText;
      return this;
    }
  }
}
