package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetProductAssetDescription {
  private Integer variantId;

  private String sku;

  private Boolean staged = true;

  private List<LocalizedStringItemInputType> description;

  private String assetKey;

  private String assetId;

  public SetProductAssetDescription() {
  }

  public SetProductAssetDescription(Integer variantId, String sku, Boolean staged,
      List<LocalizedStringItemInputType> description, String assetKey, String assetId) {
    this.variantId = variantId;
    this.sku = sku;
    this.staged = staged;
    this.description = description;
    this.assetKey = assetKey;
    this.assetId = assetId;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public String getAssetKey() {
    return assetKey;
  }

  public void setAssetKey(String assetKey) {
    this.assetKey = assetKey;
  }

  public String getAssetId() {
    return assetId;
  }

  public void setAssetId(String assetId) {
    this.assetId = assetId;
  }

  @Override
  public String toString() {
    return "SetProductAssetDescription{variantId='" + variantId + "', sku='" + sku + "', staged='" + staged + "', description='" + description + "', assetKey='" + assetKey + "', assetId='" + assetId + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductAssetDescription that = (SetProductAssetDescription) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(description, that.description) &&
        Objects.equals(assetKey, that.assetKey) &&
        Objects.equals(assetId, that.assetId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, staged, description, assetKey, assetId);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private Boolean staged = true;

    private List<LocalizedStringItemInputType> description;

    private String assetKey;

    private String assetId;

    public SetProductAssetDescription build() {
      SetProductAssetDescription result = new SetProductAssetDescription();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.staged = this.staged;
      result.description = this.description;
      result.assetKey = this.assetKey;
      result.assetId = this.assetId;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder assetKey(String assetKey) {
      this.assetKey = assetKey;
      return this;
    }

    public Builder assetId(String assetId) {
      this.assetId = assetId;
      return this;
    }
  }
}
