package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetProductAttribute {
  private Integer variantId;

  private String sku;

  private String name;

  private String value;

  private Boolean staged = true;

  public SetProductAttribute() {
  }

  public SetProductAttribute(Integer variantId, String sku, String name, String value,
      Boolean staged) {
    this.variantId = variantId;
    this.sku = sku;
    this.name = name;
    this.value = value;
    this.staged = staged;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductAttribute{variantId='" + variantId + "', sku='" + sku + "', name='" + name + "', value='" + value + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductAttribute that = (SetProductAttribute) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, name, value, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private String name;

    private String value;

    private Boolean staged = true;

    public SetProductAttribute build() {
      SetProductAttribute result = new SetProductAttribute();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.name = this.name;
      result.value = this.value;
      result.staged = this.staged;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(String value) {
      this.value = value;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
