package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetProductCategoryOrderHint {
  private String categoryId;

  private String orderHint;

  private Boolean staged = true;

  public SetProductCategoryOrderHint() {
  }

  public SetProductCategoryOrderHint(String categoryId, String orderHint, Boolean staged) {
    this.categoryId = categoryId;
    this.orderHint = orderHint;
    this.staged = staged;
  }

  public String getCategoryId() {
    return categoryId;
  }

  public void setCategoryId(String categoryId) {
    this.categoryId = categoryId;
  }

  public String getOrderHint() {
    return orderHint;
  }

  public void setOrderHint(String orderHint) {
    this.orderHint = orderHint;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductCategoryOrderHint{categoryId='" + categoryId + "', orderHint='" + orderHint + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductCategoryOrderHint that = (SetProductCategoryOrderHint) o;
    return Objects.equals(categoryId, that.categoryId) &&
        Objects.equals(orderHint, that.orderHint) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(categoryId, orderHint, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String categoryId;

    private String orderHint;

    private Boolean staged = true;

    public SetProductCategoryOrderHint build() {
      SetProductCategoryOrderHint result = new SetProductCategoryOrderHint();
      result.categoryId = this.categoryId;
      result.orderHint = this.orderHint;
      result.staged = this.staged;
      return result;
    }

    public Builder categoryId(String categoryId) {
      this.categoryId = categoryId;
      return this;
    }

    public Builder orderHint(String orderHint) {
      this.orderHint = orderHint;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
