package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SetProductDiscountValidFrom {
  private OffsetDateTime validFrom;

  public SetProductDiscountValidFrom() {
  }

  public SetProductDiscountValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  @Override
  public String toString() {
    return "SetProductDiscountValidFrom{validFrom='" + validFrom + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductDiscountValidFrom that = (SetProductDiscountValidFrom) o;
    return Objects.equals(validFrom, that.validFrom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validFrom);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime validFrom;

    public SetProductDiscountValidFrom build() {
      SetProductDiscountValidFrom result = new SetProductDiscountValidFrom();
      result.validFrom = this.validFrom;
      return result;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }
  }
}
