package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SetProductDiscountValidUntil {
  private OffsetDateTime validUntil;

  public SetProductDiscountValidUntil() {
  }

  public SetProductDiscountValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  @Override
  public String toString() {
    return "SetProductDiscountValidUntil{validUntil='" + validUntil + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductDiscountValidUntil that = (SetProductDiscountValidUntil) o;
    return Objects.equals(validUntil, that.validUntil);
  }

  @Override
  public int hashCode() {
    return Objects.hash(validUntil);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private OffsetDateTime validUntil;

    public SetProductDiscountValidUntil build() {
      SetProductDiscountValidUntil result = new SetProductDiscountValidUntil();
      result.validUntil = this.validUntil;
      return result;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }
  }
}
