package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetProductPriceKey {
  private String priceId;

  private String key;

  private Boolean staged = true;

  public SetProductPriceKey() {
  }

  public SetProductPriceKey(String priceId, String key, Boolean staged) {
    this.priceId = priceId;
    this.key = key;
    this.staged = staged;
  }

  public String getPriceId() {
    return priceId;
  }

  public void setPriceId(String priceId) {
    this.priceId = priceId;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductPriceKey{priceId='" + priceId + "', key='" + key + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductPriceKey that = (SetProductPriceKey) o;
    return Objects.equals(priceId, that.priceId) &&
        Objects.equals(key, that.key) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(priceId, key, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String priceId;

    private String key;

    private Boolean staged = true;

    public SetProductPriceKey build() {
      SetProductPriceKey result = new SetProductPriceKey();
      result.priceId = this.priceId;
      result.key = this.key;
      result.staged = this.staged;
      return result;
    }

    public Builder priceId(String priceId) {
      this.priceId = priceId;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
