package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetProductPriceMode {
  private PriceMode priceMode;

  public SetProductPriceMode() {
  }

  public SetProductPriceMode(PriceMode priceMode) {
    this.priceMode = priceMode;
  }

  public PriceMode getPriceMode() {
    return priceMode;
  }

  public void setPriceMode(PriceMode priceMode) {
    this.priceMode = priceMode;
  }

  @Override
  public String toString() {
    return "SetProductPriceMode{priceMode='" + priceMode + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductPriceMode that = (SetProductPriceMode) o;
    return Objects.equals(priceMode, that.priceMode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(priceMode);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private PriceMode priceMode;

    public SetProductPriceMode build() {
      SetProductPriceMode result = new SetProductPriceMode();
      result.priceMode = this.priceMode;
      return result;
    }

    public Builder priceMode(PriceMode priceMode) {
      this.priceMode = priceMode;
      return this;
    }
  }
}
