package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetProductPrices {
  private Integer variantId;

  private String sku;

  private List<ProductPriceDataInput> prices;

  private Boolean staged = true;

  public SetProductPrices() {
  }

  public SetProductPrices(Integer variantId, String sku, List<ProductPriceDataInput> prices,
      Boolean staged) {
    this.variantId = variantId;
    this.sku = sku;
    this.prices = prices;
    this.staged = staged;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public List<ProductPriceDataInput> getPrices() {
    return prices;
  }

  public void setPrices(List<ProductPriceDataInput> prices) {
    this.prices = prices;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductPrices{variantId='" + variantId + "', sku='" + sku + "', prices='" + prices + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductPrices that = (SetProductPrices) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(prices, that.prices) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, sku, prices, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String sku;

    private List<ProductPriceDataInput> prices;

    private Boolean staged = true;

    public SetProductPrices build() {
      SetProductPrices result = new SetProductPrices();
      result.variantId = this.variantId;
      result.sku = this.sku;
      result.prices = this.prices;
      result.staged = this.staged;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder prices(List<ProductPriceDataInput> prices) {
      this.prices = prices;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
