package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class SetProductSelectionVariantSelection {
  private ResourceIdentifierInput product;

  private ProductVariantSelectionDraft variantSelection;

  public SetProductSelectionVariantSelection() {
  }

  public SetProductSelectionVariantSelection(ResourceIdentifierInput product,
      ProductVariantSelectionDraft variantSelection) {
    this.product = product;
    this.variantSelection = variantSelection;
  }

  public ResourceIdentifierInput getProduct() {
    return product;
  }

  public void setProduct(ResourceIdentifierInput product) {
    this.product = product;
  }

  public ProductVariantSelectionDraft getVariantSelection() {
    return variantSelection;
  }

  public void setVariantSelection(ProductVariantSelectionDraft variantSelection) {
    this.variantSelection = variantSelection;
  }

  @Override
  public String toString() {
    return "SetProductSelectionVariantSelection{product='" + product + "', variantSelection='" + variantSelection + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductSelectionVariantSelection that = (SetProductSelectionVariantSelection) o;
    return Objects.equals(product, that.product) &&
        Objects.equals(variantSelection, that.variantSelection);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, variantSelection);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput product;

    private ProductVariantSelectionDraft variantSelection;

    public SetProductSelectionVariantSelection build() {
      SetProductSelectionVariantSelection result = new SetProductSelectionVariantSelection();
      result.product = this.product;
      result.variantSelection = this.variantSelection;
      return result;
    }

    public Builder product(ResourceIdentifierInput product) {
      this.product = product;
      return this;
    }

    public Builder variantSelection(ProductVariantSelectionDraft variantSelection) {
      this.variantSelection = variantSelection;
      return this;
    }
  }
}
