package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class SetProductTailoringMetaDescription {
  private List<LocalizedStringItemInputType> metaDescription;

  private Boolean staged = true;

  public SetProductTailoringMetaDescription() {
  }

  public SetProductTailoringMetaDescription(List<LocalizedStringItemInputType> metaDescription,
      Boolean staged) {
    this.metaDescription = metaDescription;
    this.staged = staged;
  }

  public List<LocalizedStringItemInputType> getMetaDescription() {
    return metaDescription;
  }

  public void setMetaDescription(List<LocalizedStringItemInputType> metaDescription) {
    this.metaDescription = metaDescription;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "SetProductTailoringMetaDescription{metaDescription='" + metaDescription + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SetProductTailoringMetaDescription that = (SetProductTailoringMetaDescription) o;
    return Objects.equals(metaDescription, that.metaDescription) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(metaDescription, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> metaDescription;

    private Boolean staged = true;

    public SetProductTailoringMetaDescription build() {
      SetProductTailoringMetaDescription result = new SetProductTailoringMetaDescription();
      result.metaDescription = this.metaDescription;
      result.staged = this.staged;
      return result;
    }

    public Builder metaDescription(List<LocalizedStringItemInputType> metaDescription) {
      this.metaDescription = metaDescription;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
